/*

     Simple USB Echo application
            
 Copyright (C) Dirk Tostmann, 2009.
              
  tostmann [at] busware [dot] de
      www.busware.de
*/

/*
  Copyright 2009  Dirk Tostmann (tostmann [at] busware . de)

  Permission to use, copy, modify, and distribute this software
  and its documentation for any purpose and without fee is hereby
  granted, provided that the above copyright notice appear in all
  copies and that both that the copyright notice and this
  permission notice and warranty disclaimer appear in supporting
  documentation, and that the name of the author not be used in
  advertising or publicity pertaining to distribution of the
  software without specific, written prior permission.

  The author disclaim all warranties with regard to this
  software, including all implied warranties of merchantability
  and fitness.  In no event shall the author be liable for any
  special, indirect or consequential damages or any damages
  whatsoever resulting from loss of use, data or profits, whether
  in an action of contract, negligence or other tortious action,
  arising out of or in connection with the use or performance of
  this software.
*/

#include <avr/io.h>

#include <avr/wdt.h>

#include <avr/interrupt.h>
#include "Descriptors.h"


#include "../../lufa/serial.h"

TASK(Worker_Task);

/* Scheduler Task List */
TASK_LIST
{
	{ Task: USB_USBTask          , TaskStatus: TASK_STOP },
	{ Task: CDC_Task             , TaskStatus: TASK_STOP },
	{ Task: Worker_Task          , TaskStatus: TASK_RUN },
};

/** Main program entry point. This routine configures the hardware required by the application, then
 *  starts the scheduler to run the application tasks.
 */

int main(void) {
     /* Disable watchdog if enabled by bootloader/fuses */
     MCUSR &= ~(1 << WDRF);
     wdt_disable();
     
     /* Disable Clock Division */
     SetSystemClockPrescaler(0);

     /* Initialize Scheduler so that it can be used */
     Scheduler_Init();
     
     /* USB Init */
     LUFA_Init();

     /* Scheduling - routine never returns, so put this last in the main function */
     Scheduler_Start();
}


TASK(Worker_Task) { // ECHO
     
     
     /* Check if Rx buffer contains data */
     if (Rx_Buffer.Elements) {
	  Buffer_StoreElement(&Tx_Buffer, Buffer_GetElement(&Rx_Buffer));
	  
     }

}

