
#include <avr/io.h>
#include <util/delay.h>
#include <avr/interrupt.h>

uint8_t bit = 0;

ISR(INT2_vect) {
     PORTC  ^= _BV(PC4);		
}

ISR(TIMER1_COMPA_vect) {

     // NULL?
     if (bit++ & 2) {
	  PORTC &= ~_BV( PC6 );
     }
	 
     TIFR1 |= _BV( OCF1A );
}

// set HIGH
ISR(TIMER1_COMPB_vect) {
     PORTC |= _BV( PC6 );
     
     TIFR1 |= _BV( OCF1B );
}

static inline void SetSystemClockPrescaler(uint8_t PrescalerMask) {
     uint8_t tmp = (1 << CLKPCE);
     __asm__ __volatile__ (
	  "in __tmp_reg__,__SREG__" "\n\t"
	  "cli" "\n\t"
	  "sts %1, %0" "\n\t"
	  "sts %1, %2" "\n\t"
	  "out __SREG__, __tmp_reg__"
	  : /* no outputs */
	  : "d" (tmp),
	  "M" (_SFR_MEM_ADDR(CLKPR)),
	  "d" (PrescalerMask)
	  : "r0");
}


int main(void) {

     /* Disable Clock Division */
     SetSystemClockPrescaler(0);
     
     // LED as output
     DDRC  |= _BV(PC4);	
     
     // Micro switch as input
     DDRD   = 0;

     // Pull RX
//     PORTD |= _BV(PD2);

     // RX Interrupt
     EICRA |= _BV( ISC21 ) | _BV( ISC20 );
//     EIMSK |= _BV( INT2 );

     // TX Timer @ 1MHz == 1us
     DDRC |= _BV( PC6 ); // OC1.A
     TCNT1  = 0;
     TCCR1A = 0;
     TCCR1B = _BV( WGM12) | _BV(CS11);   // prescale 8 - 1usec - CTC
     OCR1A  = 103;         // BitZeit
     OCR1B  = 34;          // LowZeit
     OCR1C  = 70;          // CollTest

     TIMSK1 = _BV( OCIE1A ) | _BV( OCIE1B );

     sei();

     while (1) {

	  // XOR LED
	  PORTC  ^= _BV(PC4);		
	  
	  // just wait - long or longer ...
	  if (bit_is_set( PIND, PD7)) {
	       _delay_ms(200);
	  } else {
	       _delay_ms(100);
	  }
	  
     }

     
    

}
